import java.util.*;

/**
 * Classe che rappresenta l'albero dei messaggi del newsgroup. 
 * L'albero  composto da nodi della classe TreeNode.
 * La root  un nodo fittizio con elemento del nodo nullo.
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class MsgTree {
	protected TreeNode root;
	protected Hashtable table;
	
	/**
	 * Costruttore di MsgTree che accetta come parametro un nodo 
	 * contenente un messaggio che non  risposta di nessuno
	 * @param n nodo del primo livello
	 */
	public MsgTree(TreeNode n){
		this.root=new TreeNode(null);
		this.root.setSons(n);
		n.setFather(this.root);
		table=new Hashtable();
		table.put(n.getMsg().getMsgID(),n);
	}
	
	/**
	 * Metodo che ritorna la root dell'albero, che  un nodo fittizio 
	 * con elemento del nodo nullo
	 * @return root dell'albero
	 */
	public TreeNode getRoot(){
		return this.root;
	}
	
	/**
	 * Metodo che inserisce un nuovo messaggio nell'albaero dei messaggi.
	 * Il metodo ha due parametri in ingresso il messaggio vero e proprio
	 * e il messaggio di cui il primo  risposta. Se il messaggio da inserire 
	 * non  risposta di nessuno allora il messaggio padre sar a null
	 * @param mess messaggio da inserire nell'albero dei messaggi 
	 * @param dad messaggio di cui mess  risposta. E' a null se mess non  una risposta
	 * @return true se l'insrimento  andato a buon fine, false altrimenti
	 * @throws NoSuchNodeException
	 */
	public synchronized boolean insert(Msg mess,Msg dad)throws NoSuchNodeException{
		TreeNode cur=new TreeNode(mess);
		if(dad==null){
			this.getRoot().setSons(cur);
			cur.setFather(this.getRoot());
			table.put(cur.getMsg().getMsgID(),cur);
		}
		else{
			try{
				TreeNode father=(TreeNode)table.get(dad.getMsgID());
				if(father==null) return false;
				father.setSons(cur);
				cur.setFather(father);
			}
			catch (NullPointerException e){
				throw new NoSuchNodeException();
			}
		}
		return true;
	}
	
	/**
	 * Metodo che permette di ottenere una tabella di accesso rapido
	 * ai nodi contenuti nell'albero
	 * @return una Hashtable, in cui la chiave  l'ID del messaggio e 
	 * l'oggetto il nodo TreeNode che contiene il messaggio
	 */
	public Hashtable getTable(){
		return this.table;
	}
	
	/**
	 * Metodo che ritorna la stringa rappresentante l'albero
	 * return la stringa rappresentante l'albero di messaggi
	 */
	public String toString(){
		String tree="";
		if(this.root.getSons()!=null){
			for(int i=0;i<this.root.getSons().size();i++){
				if(this.root.getSons().get(i)!=null)
					tree+=this.root.getSons().get(i).toString()+"\n";
			}
			return tree;
		}
		return null;
	}
}
